"""
This file is auto generated by the code generation script.
Do not modify this file manually.
Use the `make codegen` command to regenerate.

当前文件为自动生成的控制 API 客户端代码。请勿手动修改此文件。
使用 `make codegen` 命令重新生成。

source: codegen/configs/agent_runtime_control_api.yaml


Agent Runtime 管控链路 API
"""

from typing import Dict, Optional

from alibabacloud_agentrun20250910.models import (
    AgentRuntime,
    AgentRuntimeEndpoint,
    CreateAgentRuntimeEndpointInput,
    CreateAgentRuntimeEndpointRequest,
    CreateAgentRuntimeInput,
    CreateAgentRuntimeRequest,
    GetAgentRuntimeRequest,
    ListAgentRuntimeEndpointsOutput,
    ListAgentRuntimeEndpointsRequest,
    ListAgentRuntimesOutput,
    ListAgentRuntimesRequest,
    ListAgentRuntimeVersionsOutput,
    ListAgentRuntimeVersionsRequest,
    UpdateAgentRuntimeEndpointInput,
    UpdateAgentRuntimeEndpointRequest,
    UpdateAgentRuntimeInput,
    UpdateAgentRuntimeRequest,
)
from alibabacloud_tea_openapi.exceptions._client import ClientException
from alibabacloud_tea_openapi.exceptions._server import ServerException
from alibabacloud_tea_util.models import RuntimeOptions
import pydash

from agentrun.utils.config import Config
from agentrun.utils.control_api import ControlAPI
from agentrun.utils.exception import ClientError, ServerError
from agentrun.utils.log import logger


class AgentRuntimeControlAPI(ControlAPI):
    """Agent Runtime 管控链路 API"""

    def __init__(self, config: Optional[Config] = None):
        """初始化 API 客户端

        Args:
            config: 全局配置对象
        """
        super().__init__(config)

    def create_agent_runtime(
        self,
        input: CreateAgentRuntimeInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """创建 Agent Runtime

        Args:
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_agent_runtime_with_options(
                CreateAgentRuntimeRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_agent_runtime_async(
        self,
        input: CreateAgentRuntimeInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """创建 Agent Runtime

        Args:
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_agent_runtime_with_options_async(
                CreateAgentRuntimeRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_agent_runtime(
        self,
        agent_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """删除 Agent Runtime

        Args:
            agent_id: Agent Runtime ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 删除结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_agent_runtime_with_options(
                agent_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request: {[agent_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_agent_runtime_async(
        self,
        agent_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """删除 Agent Runtime

        Args:
            agent_id: Agent Runtime ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 删除结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.delete_agent_runtime_with_options_async(
                agent_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request: {[agent_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_agent_runtime(
        self,
        agent_id: str,
        input: UpdateAgentRuntimeInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """创建 Agent Runtime

        Args:
            agent_id: Agent Runtime ID
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_agent_runtime_with_options(
                agent_id,
                UpdateAgentRuntimeRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_agent_runtime_async(
        self,
        agent_id: str,
        input: UpdateAgentRuntimeInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """创建 Agent Runtime

        Args:
            agent_id: Agent Runtime ID
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.update_agent_runtime_with_options_async(
                agent_id,
                UpdateAgentRuntimeRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_agent_runtime(
        self,
        agent_id: str,
        input: GetAgentRuntimeRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """获取 Agent Runtime

        Args:
            agent_id: Agent Runtime ID
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_agent_runtime_with_options(
                agent_id,
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_agent_runtime_async(
        self,
        agent_id: str,
        input: GetAgentRuntimeRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntime:
        """获取 Agent Runtime

        Args:
            agent_id: Agent Runtime ID
            input: Agent Runtime 配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntime: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_agent_runtime_with_options_async(
                agent_id,
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_agent_runtime, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_agent_runtimes(
        self,
        input: ListAgentRuntimesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimesOutput:
        """枚举 Agent Runtime

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimesOutput: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_agent_runtimes_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_agent_runtimes, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_agent_runtimes_async(
        self,
        input: ListAgentRuntimesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimesOutput:
        """枚举 Agent Runtime

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimesOutput: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_agent_runtimes_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_agent_runtimes, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def create_agent_runtime_endpoint(
        self,
        agent_id: str,
        input: CreateAgentRuntimeEndpointInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """创建 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            input: 端点配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_agent_runtime_endpoint_with_options(
                agent_id,
                CreateAgentRuntimeEndpointRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_agent_runtime_endpoint_async(
        self,
        agent_id: str,
        input: CreateAgentRuntimeEndpointInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """创建 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            input: 端点配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.create_agent_runtime_endpoint_with_options_async(
                    agent_id,
                    CreateAgentRuntimeEndpointRequest(body=input),
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api create_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_agent_runtime_endpoint(
        self,
        agent_id: str,
        endpoint_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """删除 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_agent_runtime_endpoint_with_options(
                agent_id,
                endpoint_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_agent_runtime_endpoint_async(
        self,
        agent_id: str,
        endpoint_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """删除 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.delete_agent_runtime_endpoint_with_options_async(
                    agent_id,
                    endpoint_id,
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api delete_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_agent_runtime_endpoint(
        self,
        agent_id: str,
        endpoint_id: str,
        input: UpdateAgentRuntimeEndpointInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """更新 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID
            input: 端点配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_agent_runtime_endpoint_with_options(
                agent_id,
                endpoint_id,
                UpdateAgentRuntimeEndpointRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_agent_runtime_endpoint_async(
        self,
        agent_id: str,
        endpoint_id: str,
        input: UpdateAgentRuntimeEndpointInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """更新 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID
            input: 端点配置

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.update_agent_runtime_endpoint_with_options_async(
                    agent_id,
                    endpoint_id,
                    UpdateAgentRuntimeEndpointRequest(body=input),
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api update_agent_runtime_endpoint, request Request"
                f" ID: {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_agent_runtime_endpoint(
        self,
        agent_id: str,
        endpoint_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """获取 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_agent_runtime_endpoint_with_options(
                agent_id,
                endpoint_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_agent_runtime_endpoint, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_agent_runtime_endpoint_async(
        self,
        agent_id: str,
        endpoint_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> AgentRuntimeEndpoint:
        """获取 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            endpoint_id: 端点 ID

            headers: 请求头
            config: 配置

        Returns:
            AgentRuntimeEndpoint: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.get_agent_runtime_endpoint_with_options_async(
                    agent_id,
                    endpoint_id,
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api get_agent_runtime_endpoint, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,endpoint_id,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    endpoint_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_agent_runtime_endpoints(
        self,
        agent_id: str,
        input: ListAgentRuntimeEndpointsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimeEndpointsOutput:
        """枚举 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimeEndpointsOutput: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_agent_runtime_endpoints_with_options(
                agent_id,
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_agent_runtime_endpoints, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_agent_runtime_endpoints_async(
        self,
        agent_id: str,
        input: ListAgentRuntimeEndpointsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimeEndpointsOutput:
        """枚举 Agent Runtime 访问端点

        Args:
            agent_id: Agent Runtime ID
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimeEndpointsOutput: 创建的 Runtime 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.list_agent_runtime_endpoints_with_options_async(
                    agent_id,
                    input,
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api list_agent_runtime_endpoints, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_agent_runtime_versions(
        self,
        agent_id: str,
        input: ListAgentRuntimeVersionsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimeVersionsOutput:
        """枚举 Agent Runtime 版本

        Args:
            agent_id: Agent Runtime ID
            input: 版本配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimeVersionsOutput: Agent Runtime 版本

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_agent_runtime_versions_with_options(
                agent_id,
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_agent_runtime_versions, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_agent_runtime_versions_async(
        self,
        agent_id: str,
        input: ListAgentRuntimeVersionsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListAgentRuntimeVersionsOutput:
        """枚举 Agent Runtime 版本

        Args:
            agent_id: Agent Runtime ID
            input: 版本配置

            headers: 请求头
            config: 配置

        Returns:
            ListAgentRuntimeVersionsOutput: Agent Runtime 版本

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = (
                await client.list_agent_runtime_versions_with_options_async(
                    agent_id,
                    input,
                    headers=headers or {},
                    runtime=RuntimeOptions(),
                )
            )

            logger.debug(
                "request api list_agent_runtime_versions, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[agent_id,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    agent_id,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e
