"""
This file is auto generated by the code generation script.
Do not modify this file manually.
Use the `make codegen` command to regenerate.

当前文件为自动生成的控制 API 客户端代码。请勿手动修改此文件。
使用 `make codegen` 命令重新生成。

source: codegen/configs/credential_control_api.yaml


Credential 管控链路 API
"""

from typing import Dict, Optional

from alibabacloud_agentrun20250910.models import (
    CreateCredentialInput,
    CreateCredentialRequest,
    Credential,
    ListCredentialsOutput,
    ListCredentialsRequest,
    UpdateCredentialInput,
    UpdateCredentialRequest,
)
from alibabacloud_tea_openapi.exceptions._client import ClientException
from alibabacloud_tea_openapi.exceptions._server import ServerException
from alibabacloud_tea_util.models import RuntimeOptions
import pydash

from agentrun.utils.config import Config
from agentrun.utils.control_api import ControlAPI
from agentrun.utils.exception import ClientError, ServerError
from agentrun.utils.log import logger


class CredentialControlAPI(ControlAPI):
    """Credential 管控链路 API"""

    def __init__(self, config: Optional[Config] = None):
        """初始化 API 客户端

        Args:
            config: 全局配置对象
        """
        super().__init__(config)

    def create_credential(
        self,
        input: CreateCredentialInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """创建凭证

        Args:
            input: 凭证配置

            headers: 请求头
            config: 配置

        Returns:
            Credential: 创建的凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_credential_with_options(
                CreateCredentialRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_credential, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_credential_async(
        self,
        input: CreateCredentialInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """创建凭证

        Args:
            input: 凭证配置

            headers: 请求头
            config: 配置

        Returns:
            Credential: 创建的凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_credential_with_options_async(
                CreateCredentialRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_credential, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_credential(
        self,
        credential_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """删除凭证

        Args:
            credential_name: 凭证名称

            headers: 请求头
            config: 配置

        Returns:
            Credential: 删除凭证的结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_credential_with_options(
                credential_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    credential_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_credential_async(
        self,
        credential_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """删除凭证

        Args:
            credential_name: 凭证名称

            headers: 请求头
            config: 配置

        Returns:
            Credential: 删除凭证的结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.delete_credential_with_options_async(
                credential_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    credential_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_credential(
        self,
        credential_name: str,
        input: UpdateCredentialInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """更新凭证

        Args:
            credential_name: 凭证名称
            input: 凭证配置

            headers: 请求头
            config: 配置

        Returns:
            Credential: 更新后的凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_credential_with_options(
                credential_name,
                UpdateCredentialRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    credential_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_credential_async(
        self,
        credential_name: str,
        input: UpdateCredentialInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """更新凭证

        Args:
            credential_name: 凭证名称
            input: 凭证配置

            headers: 请求头
            config: 配置

        Returns:
            Credential: 更新后的凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.update_credential_with_options_async(
                credential_name,
                UpdateCredentialRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    credential_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_credential(
        self,
        credential_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """获取凭证

        Args:
            credential_name: 凭证名称

            headers: 请求头
            config: 配置

        Returns:
            Credential: 凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_credential_with_options(
                credential_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    credential_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_credential_async(
        self,
        credential_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Credential:
        """获取凭证

        Args:
            credential_name: 凭证名称

            headers: 请求头
            config: 配置

        Returns:
            Credential: 凭证对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_credential_with_options_async(
                credential_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_credential, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[credential_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    credential_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_credentials(
        self,
        input: ListCredentialsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListCredentialsOutput:
        """列出凭证

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListCredentialsOutput: 凭证列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_credentials_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_credentials, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_credentials_async(
        self,
        input: ListCredentialsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListCredentialsOutput:
        """列出凭证

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListCredentialsOutput: 凭证列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_credentials_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_credentials, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e
