"""Model Service 模块 / Model Service Module"""

from litellm.litellm_core_utils.streaming_handler import CustomStreamWrapper
from litellm.types.utils import ModelResponse

from .api import ModelCompletionAPI, ModelControlAPI, ModelDataAPI
from .client import ModelClient
from .model import (
    BackendType,
    ModelFeatures,
    ModelInfoConfig,
    ModelParameterRule,
    ModelProperties,
    ModelProxyCreateInput,
    ModelProxyListInput,
    ModelProxyUpdateInput,
    ModelServiceCreateInput,
    ModelServiceListInput,
    ModelServiceUpdateInput,
    ModelType,
    Provider,
    ProviderSettings,
    ProxyConfig,
    ProxyConfigEndpoint,
    ProxyConfigFallback,
    ProxyConfigPolicies,
)
from .model_proxy import ModelProxy
from .model_service import ModelService

__all__ = [
    # base
    "ModelClient",
    "ModelService",
    "ModelProxy",
    "ModelControlAPI",
    "ModelCompletionAPI",
    "ModelDataAPI",
    # enum
    "BackendType",
    "ModelType",
    "Provider",
    # inner model
    "ProviderSettings",
    "ModelFeatures",
    "ModelProperties",
    "ModelParameterRule",
    "ModelInfoConfig",
    "ProxyConfigEndpoint",
    "ProxyConfigFallback",
    "ProxyConfigPolicies",
    "ProxyConfig",
    # api model
    "ModelServiceCreateInput",
    "ModelServiceUpdateInput",
    "ModelServiceListInput",
    "ModelProxyCreateInput",
    "ModelProxyUpdateInput",
    "ModelProxyListInput",
    # others
    "ModelResponse",
    "CustomStreamWrapper",
]
