"""
This file is auto generated by the code generation script.
Do not modify this file manually.
Use the `make codegen` command to regenerate.

当前文件为自动生成的控制 API 客户端代码。请勿手动修改此文件。
使用 `make codegen` 命令重新生成。

source: codegen/configs/model_control_api.yaml


Model 管控链路 API
"""

from typing import Dict, Optional

from alibabacloud_agentrun20250910.models import (
    CreateModelProxyInput,
    CreateModelProxyRequest,
    CreateModelServiceInput,
    CreateModelServiceRequest,
    ListModelProxiesOutput,
    ListModelProxiesRequest,
    ListModelServicesOutput,
    ListModelServicesRequest,
    ModelProxy,
    ModelService,
    UpdateModelProxyInput,
    UpdateModelProxyRequest,
    UpdateModelServiceInput,
    UpdateModelServiceRequest,
)
from alibabacloud_tea_openapi.exceptions._client import ClientException
from alibabacloud_tea_openapi.exceptions._server import ServerException
from alibabacloud_tea_util.models import RuntimeOptions
import pydash

from agentrun.utils.config import Config
from agentrun.utils.control_api import ControlAPI
from agentrun.utils.exception import ClientError, ServerError
from agentrun.utils.log import logger


class ModelControlAPI(ControlAPI):
    """Model 管控链路 API"""

    def __init__(self, config: Optional[Config] = None):
        """初始化 API 客户端

        Args:
            config: 全局配置对象
        """
        super().__init__(config)

    def create_model_service(
        self,
        input: CreateModelServiceInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """创建模型服务

        Args:
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 创建的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_model_service_with_options(
                CreateModelServiceRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_model_service, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_model_service_async(
        self,
        input: CreateModelServiceInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """创建模型服务

        Args:
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 创建的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_model_service_with_options_async(
                CreateModelServiceRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_model_service, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_model_service(
        self,
        model_service_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """删除模型服务

        Args:
            model_service_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 无返回值

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_model_service_with_options(
                model_service_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_service_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_model_service_async(
        self,
        model_service_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """删除模型服务

        Args:
            model_service_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 无返回值

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.delete_model_service_with_options_async(
                model_service_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_service_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_model_service(
        self,
        model_service_name: str,
        input: UpdateModelServiceInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """更新模型服务

        Args:
            model_service_name: 模型服务名称
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 更新后的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_model_service_with_options(
                model_service_name,
                UpdateModelServiceRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_service_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_model_service_async(
        self,
        model_service_name: str,
        input: UpdateModelServiceInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """更新模型服务

        Args:
            model_service_name: 模型服务名称
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 更新后的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.update_model_service_with_options_async(
                model_service_name,
                UpdateModelServiceRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_service_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_model_service(
        self,
        model_service_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """获取模型服务

        Args:
            model_service_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_model_service_with_options(
                model_service_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_service_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_model_service_async(
        self,
        model_service_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelService:
        """获取模型服务

        Args:
            model_service_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelService: 模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_model_service_with_options_async(
                model_service_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_model_service, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_service_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_service_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_model_services(
        self,
        input: ListModelServicesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListModelServicesOutput:
        """列出模型服务

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListModelServicesOutput: 模型服务列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_model_services_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_model_services, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_model_services_async(
        self,
        input: ListModelServicesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListModelServicesOutput:
        """列出模型服务

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListModelServicesOutput: 模型服务列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_model_services_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_model_services, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def create_model_proxy(
        self,
        input: CreateModelProxyInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """创建模型服务

        Args:
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 创建的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_model_proxy_with_options(
                CreateModelProxyRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_model_proxy_async(
        self,
        input: CreateModelProxyInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """创建模型服务

        Args:
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 创建的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_model_proxy_with_options_async(
                CreateModelProxyRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_model_proxy(
        self,
        model_proxy_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """删除模型服务

        Args:
            model_proxy_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 无返回值

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_model_proxy_with_options(
                model_proxy_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_model_proxy_async(
        self,
        model_proxy_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """删除模型服务

        Args:
            model_proxy_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 无返回值

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.delete_model_proxy_with_options_async(
                model_proxy_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_model_proxy(
        self,
        model_proxy_name: str,
        input: UpdateModelProxyInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """更新模型服务

        Args:
            model_proxy_name: 模型服务名称
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 更新后的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_model_proxy_with_options(
                model_proxy_name,
                UpdateModelProxyRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_model_proxy_async(
        self,
        model_proxy_name: str,
        input: UpdateModelProxyInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """更新模型服务

        Args:
            model_proxy_name: 模型服务名称
            input: 模型服务配置

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 更新后的模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.update_model_proxy_with_options_async(
                model_proxy_name,
                UpdateModelProxyRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_model_proxy(
        self,
        model_proxy_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """获取模型服务

        Args:
            model_proxy_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_model_proxy_with_options(
                model_proxy_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_model_proxy_async(
        self,
        model_proxy_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ModelProxy:
        """获取模型服务

        Args:
            model_proxy_name: 模型服务名称

            headers: 请求头
            config: 配置

        Returns:
            ModelProxy: 模型服务对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_model_proxy_with_options_async(
                model_proxy_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_model_proxy, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[model_proxy_name,]}\n  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    model_proxy_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_model_proxies(
        self,
        input: ListModelProxiesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListModelProxiesOutput:
        """列出模型服务

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListModelProxiesOutput: 模型服务列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_model_proxies_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_model_proxies, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_model_proxies_async(
        self,
        input: ListModelProxiesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListModelProxiesOutput:
        """列出模型服务

        Args:
            input: 查询参数

            headers: 请求头
            config: 配置

        Returns:
            ListModelProxiesOutput: 模型服务列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_model_proxies_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_model_proxies, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e
