"""
This file is auto generated by the code generation script.
Do not modify this file manually.
Use the `make codegen` command to regenerate.

当前文件为自动生成的控制 API 客户端代码。请勿手动修改此文件。
使用 `make codegen` 命令重新生成。

source: codegen/configs/sandbox_control_api.yaml


Sandbox 管控链路 API
"""

from typing import Dict, Optional

from alibabacloud_agentrun20250910.models import (
    CreateSandboxInput,
    CreateSandboxRequest,
    CreateTemplateInput,
    CreateTemplateRequest,
    ListSandboxesOutput,
    ListSandboxesRequest,
    ListTemplatesOutput,
    ListTemplatesRequest,
    Sandbox,
    Template,
    UpdateTemplateInput,
    UpdateTemplateRequest,
)
from alibabacloud_tea_openapi.exceptions._client import ClientException
from alibabacloud_tea_openapi.exceptions._server import ServerException
from alibabacloud_tea_util.models import RuntimeOptions
import pydash

from agentrun.utils.config import Config
from agentrun.utils.control_api import ControlAPI
from agentrun.utils.exception import ClientError, ServerError
from agentrun.utils.log import logger


class SandboxControlAPI(ControlAPI):
    """Sandbox 管控链路 API"""

    def __init__(self, config: Optional[Config] = None):
        """初始化 API 客户端

        Args:
            config: 全局配置对象
        """
        super().__init__(config)

    def create_template(
        self,
        input: CreateTemplateInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """创建 Sandbox Template

        Args:
            input: Template 配置

            headers: 请求头
            config: 配置

        Returns:
            Template: 创建的 Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_template_with_options(
                CreateTemplateRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_template_async(
        self,
        input: CreateTemplateInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """创建 Sandbox Template

        Args:
            input: Template 配置

            headers: 请求头
            config: 配置

        Returns:
            Template: 创建的 Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_template_with_options_async(
                CreateTemplateRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def delete_template(
        self,
        template_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """删除 Sandbox Template

        Args:
            template_name: Template 名称

            headers: 请求头
            config: 配置

        Returns:
            Template: 删除结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.delete_template_with_options(
                template_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[template_name,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    template_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def delete_template_async(
        self,
        template_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """删除 Sandbox Template

        Args:
            template_name: Template 名称

            headers: 请求头
            config: 配置

        Returns:
            Template: 删除结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.delete_template_with_options_async(
                template_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api delete_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[template_name,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    template_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def update_template(
        self,
        template_name: str,
        input: UpdateTemplateInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """更新 Sandbox Template

        Args:
            template_name: Template 名称
            input: Template 配置

            headers: 请求头
            config: 配置

        Returns:
            Template: 更新的 Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.update_template_with_options(
                template_name,
                UpdateTemplateRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_template, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[template_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    template_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def update_template_async(
        self,
        template_name: str,
        input: UpdateTemplateInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """更新 Sandbox Template

        Args:
            template_name: Template 名称
            input: Template 配置

            headers: 请求头
            config: 配置

        Returns:
            Template: 更新的 Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.update_template_with_options_async(
                template_name,
                UpdateTemplateRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api update_template, request Request ID:"
                f" {response.body.request_id}\n  request:"
                f" {[template_name,input.to_map(),]}\n  response:"
                f" {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    template_name,
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_template(
        self,
        template_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """获取 Sandbox Template

        Args:
            template_name: Template 名称

            headers: 请求头
            config: 配置

        Returns:
            Template: Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_template_with_options(
                template_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[template_name,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    template_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_template_async(
        self,
        template_name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Template:
        """获取 Sandbox Template

        Args:
            template_name: Template 名称

            headers: 请求头
            config: 配置

        Returns:
            Template: Template 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_template_with_options_async(
                template_name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_template, request Request ID:"
                f" {response.body.request_id}\n  request: {[template_name,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    template_name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_templates(
        self,
        input: ListTemplatesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListTemplatesOutput:
        """枚举 Sandbox Templates

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListTemplatesOutput: Template 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_templates_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_templates, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_templates_async(
        self,
        input: ListTemplatesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListTemplatesOutput:
        """枚举 Sandbox Templates

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListTemplatesOutput: Template 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_templates_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_templates, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def create_sandbox(
        self,
        input: CreateSandboxInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """创建 Sandbox

        Args:
            input: Sandbox 配置

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: 创建的 Sandbox 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.create_sandbox_with_options(
                CreateSandboxRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def create_sandbox_async(
        self,
        input: CreateSandboxInput,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """创建 Sandbox

        Args:
            input: Sandbox 配置

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: 创建的 Sandbox 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.create_sandbox_with_options_async(
                CreateSandboxRequest(body=input),
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api create_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def stop_sandbox(
        self,
        sandbox_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """停止 Sandbox

        Args:
            sandbox_id: Sandbox ID

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: 停止结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.stop_sandbox_with_options(
                sandbox_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api stop_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[sandbox_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    sandbox_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def stop_sandbox_async(
        self,
        sandbox_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """停止 Sandbox

        Args:
            sandbox_id: Sandbox ID

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: 停止结果

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.stop_sandbox_with_options_async(
                sandbox_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api stop_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[sandbox_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    sandbox_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def get_sandbox(
        self,
        sandbox_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """获取 Sandbox

        Args:
            sandbox_id: Sandbox ID

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: Sandbox 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.get_sandbox_with_options(
                sandbox_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[sandbox_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    sandbox_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_sandbox_async(
        self,
        sandbox_id: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Sandbox:
        """获取 Sandbox

        Args:
            sandbox_id: Sandbox ID

            headers: 请求头
            config: 配置

        Returns:
            Sandbox: Sandbox 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.get_sandbox_with_options_async(
                sandbox_id,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_sandbox, request Request ID:"
                f" {response.body.request_id}\n  request: {[sandbox_id,]}\n "
                f" response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    sandbox_id,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e

    def list_sandboxes(
        self,
        input: ListSandboxesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListSandboxesOutput:
        """枚举 Sandboxes

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListSandboxesOutput: Sandbox 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = client.list_sandboxes_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_sandboxes, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_sandboxes_async(
        self,
        input: ListSandboxesRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListSandboxesOutput:
        """枚举 Sandboxes

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListSandboxesOutput: Sandbox 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_client(config)
            response = await client.list_sandboxes_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_sandboxes, request Request ID:"
                f" {response.body.request_id}\n  request: {[input.to_map(),]}\n"
                f"  response: {response.body.data}"
            )

            return response.body.data
        except ClientException as e:
            raise ClientError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                e.data.get("message", e.message),
                request_id=e.request_id,
            ) from e
