"""
This file is auto generated by the code generation script.
Do not modify this file manually.
Use the `make codegen` command to regenerate.

当前文件为自动生成的控制 API 客户端代码。请勿手动修改此文件。
使用 `make codegen` 命令重新生成。

source: codegen/configs/toolset_control_api.yaml


Tool 管控链路 API
"""

from typing import Dict, Optional

from alibabacloud_devs20230714.models import (
    ListToolsetsRequest,
    ListToolsetsResponseBody,
    Toolset,
)
from alibabacloud_tea_openapi.exceptions._client import ClientException
from alibabacloud_tea_openapi.exceptions._server import ServerException
from alibabacloud_tea_util.models import RuntimeOptions
import pydash

from agentrun.utils.config import Config
from agentrun.utils.control_api import ControlAPI
from agentrun.utils.exception import ClientError, ServerError
from agentrun.utils.log import logger


class ToolControlAPI(ControlAPI):
    """Tool 管控链路 API"""

    def __init__(self, config: Optional[Config] = None):
        """初始化 API 客户端

        Args:
            config: 全局配置对象
        """
        super().__init__(config)

    def get_toolset(
        self,
        name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Toolset:
        """获取工具

        Args:
            name: Tool 名称

            headers: 请求头
            config: 配置

        Returns:
            Toolset: ToolSet 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_devs_client(config)
            response = client.get_toolset_with_options(
                name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_toolset, request Request ID:"
                f" {response.headers['x-acs-request-id'] if response.headers else ''}\n"
                f"  request: {[name,]}\n  response: {response.body}"
            )

            return response.body
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def get_toolset_async(
        self,
        name: str,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> Toolset:
        """获取工具

        Args:
            name: Tool 名称

            headers: 请求头
            config: 配置

        Returns:
            Toolset: ToolSet 对象

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_devs_client(config)
            response = await client.get_toolset_with_options_async(
                name,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api get_toolset, request Request ID:"
                f" {response.headers['x-acs-request-id'] if response.headers else ''}\n"
                f"  request: {[name,]}\n  response: {response.body}"
            )

            return response.body
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    name,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    def list_toolsets(
        self,
        input: ListToolsetsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListToolsetsResponseBody:
        """枚举 ToolSets

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListToolsetsResponseBody: ToolSet 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_devs_client(config)
            response = client.list_toolsets_with_options(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_toolsets, request Request ID:"
                f" {response.headers['x-acs-request-id'] if response.headers else ''}\n"
                f"  request: {[input.to_map(),]}\n  response: {response.body}"
            )

            return response.body
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e

    async def list_toolsets_async(
        self,
        input: ListToolsetsRequest,
        headers: Optional[Dict[str, str]] = None,
        config: Optional[Config] = None,
    ) -> ListToolsetsResponseBody:
        """枚举 ToolSets

        Args:
            input: 枚举的配置

            headers: 请求头
            config: 配置

        Returns:
            ListToolsetsResponseBody: ToolSet 列表

        Raises:
            AgentRuntimeError: 调用失败时抛出
            ClientError: 客户端错误
            ServerError: 服务器错误
            APIError: 运行时错误
        """

        try:
            client = self._get_devs_client(config)
            response = await client.list_toolsets_with_options_async(
                input,
                headers=headers or {},
                runtime=RuntimeOptions(),
            )

            logger.debug(
                "request api list_toolsets, request Request ID:"
                f" {response.headers['x-acs-request-id'] if response.headers else ''}\n"
                f"  request: {[input.to_map(),]}\n  response: {response.body}"
            )

            return response.body
        except ClientException as e:
            raise ClientError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
                request=[
                    input,
                ],
            ) from e
        except ServerException as e:
            raise ServerError(
                e.status_code,
                pydash.get(e, "data.message", pydash.get(e, "message", "")),
                request_id=e.request_id,
            ) from e
